// onboarding-flows.js

const onboardingFlows = {

  // ── Popup flow — shown once after first login ──────────────────────────────
  first_time_user: [
    {
      mode: "center",
      title: "👋 Welcome to LinkedVue!",
      text: "LinkedVue turns LinkedIn into your outbound machine.\n\nFirst: make sure you're logged in (you are — great! ✓)\n\nThis quick tour shows you exactly how to use it.\n\nTakes 60 seconds — let's go."
    },
    {
      mode: "center",
      title: "Step 1 — Set Up First",
      text: "Open the Dashboard from the top-right corner of the popup.\n\nThere you'll:\n• Set your ICP (ideal customer profile)\n• Create message templates\n\nWithout these, the extension won't know who to target or what to say.\n\nIf you haven't logged in yet — close this, log in first, then come back here."
    },
    {
      mode: "center",
      title: "Step 2 — Save Templates",
      text: "In Dashboard → Templates, create your 3-step outreach sequence.\n\nEach template has:\n• Message 1 — first touchpoint\n• Message 2 — follow-up\n• Message 3 — final nudge\n\nYou can create multiple templates for different audiences."
    },
    {
      mode: "center",
      title: "Step 3 — Go to a LinkedIn Profile",
      text: "Open any LinkedIn profile and this popup will show their details.\n\n• Add their first name\n• Apply a template\n• Copy Message 1 and paste it into LinkedIn\n• Click 'Mark Sent'\n\nLinkedVue will automatically remind you when Message 2 is due."
    },
    {
      mode: "center",
      title: "Step 4 — Not Connected Yet?",
      text: "If you haven't connected with someone yet:\n\n• Send them a LinkedIn invite\n• Add their name and apply a template\n• When they accept, open their profile — Message 1 will be ready to copy and send\n\nLinkedVue tracks where each person is in the sequence."
    },
    {
      mode: "center",
      title: "Step 5 — Reminders & Scheduling",
      text: "You can schedule any profile to pop up automatically on a specific date.\n\nUse it to:\n• Send the next message at the right time\n• Add a note to follow up on something specific\n• Keep your pipeline moving without a CRM"
    },
    {
      mode: "center",
      title: "Step 6 — AI Messages",
      text: "On any LinkedIn profile:\n\n• Copy the top section of their profile\n• Paste it into the AI section\n• Click Generate\n\nLinkedVue creates a personalised message based on their background and your ICP settings.\n\nCopy, paste, send."
    },
    {
      mode: "center",
      title: "Step 7 — Import CSV",
      text: "Have a list of leads from an email campaign or LinkedIn export?\n\nGo to Dashboard → Import and upload your CSV.\n\nAll profiles will be imported and ready for outreach."
    },
    {
      mode: "center",
      title: "You're All Set! 🚀",
      text: "Here's your quick reference:\n\n1. Dashboard → Set ICP + Create Templates\n2. Go to LinkedIn profile → Apply template → Copy & send\n3. Mark sent → LinkedVue reminds you for next message\n4. Dashboard → Check today's actions and stats\n\nOpen the Dashboard now to get started."
    }
  ],

  // ── Dashboard flow — shown when user opens dashboard after popup onboarding ─
  dashboard_tour: [
    {
      mode: "center",
      title: "📊 Welcome to your Dashboard",
      text: "This is your outreach command centre.\n\nLet's take a quick look at what's here."
    },
    {
      selector: "#statsSection",
      title: "Your Stats",
      text: "See how many messages you've sent today and this week, and how many profiles are due for follow-up."
    },
    {
      selector: "#templatesSection",
      title: "Templates",
      text: "Create and manage your outreach sequences here.\n\nEach template has 3 messages. Once saved, apply them to profiles directly from the popup."
    },
    {
      selector: "#importSection",
      title: "Import CSV",
      text: "Import a list of leads from a LinkedIn export or email campaign.\n\nAll profiles are saved and ready for outreach."
    },
    {
      selector: "#openIcpBtnDashboard",
      title: "ICP & AI Settings ← Start Here",
      text: "Set your Ideal Customer Profile — industries, personas, regions, and your offer.\n\nThis powers both the ICP score on each profile and the AI message generator.\n\nSet this up before anything else."
    }
  ]

};