// popup-inline.js
// Replaces the inline <script> block in popup.html

// Collapsible sections
document.querySelectorAll('.section-header').forEach(h => {
  h.addEventListener('click', () => h.closest('.section').classList.toggle('open'));
});

// Copy AI message
document.getElementById('copyAiMsgBtn')?.addEventListener('click', () => {
  const msg = document.getElementById('aiMessageBox')?.value;
  if (!msg) return;
  navigator.clipboard.writeText(msg);
  const btn = document.getElementById('copyAiMsgBtn');
  const orig = btn.textContent;
  btn.textContent = 'Copied ✓';
  setTimeout(() => btn.textContent = orig, 1500);
});

// Schedule: auto-save on datetime pick, show last used time
const schedCal = document.getElementById('scheduleCalendar');
const schedLastRow = document.getElementById('schedLastRow');
const schedLastTime = document.getElementById('schedLastTime');
const useLastBtn = document.getElementById('useLastSchedBtn');

// Load last used schedule time
chrome.storage.local.get('lastScheduleTime', (res) => {
  if (res.lastScheduleTime) {
    const d = new Date(res.lastScheduleTime);
    schedLastTime.textContent = d.toLocaleString([], {month:'short',day:'numeric',hour:'2-digit',minute:'2-digit'});
    schedLastRow.style.display = 'flex';
  }
});

// Auto-save when user picks datetime
schedCal?.addEventListener('change', () => {
  const val = schedCal.value;
  if (!val) return;
  chrome.storage.local.set({ lastScheduleTime: new Date(val).toISOString() });
  const d = new Date(val);
  schedLastTime.textContent = d.toLocaleString([], {month:'short',day:'numeric',hour:'2-digit',minute:'2-digit'});
  schedLastRow.style.display = 'flex';
  document.getElementById('scheduleInput').value = val;
  document.getElementById('confirmScheduleBtn')?.click();
});

// Use last time button
useLastBtn?.addEventListener('click', () => {
  chrome.storage.local.get('lastScheduleTime', (res) => {
    if (!res.lastScheduleTime) return;
    const iso = new Date(res.lastScheduleTime);
    const pad = n => String(n).padStart(2,'0');
    const local = `${iso.getFullYear()}-${pad(iso.getMonth()+1)}-${pad(iso.getDate())}T${pad(iso.getHours())}:${pad(iso.getMinutes())}`;
    schedCal.value = local;
    schedCal.dispatchEvent(new Event('change'));
  });
});

// Mark sent visual feedback
document.getElementById('markSentBtn')?.addEventListener('click', function() {
  this.classList.add('confirmed');
  this.textContent = '✓ Sent!';
  setTimeout(() => {
    this.classList.remove('confirmed');
    this.textContent = '✓ Mark Sent';
  }, 2000);
}, true);